package com.ving.gasmileage;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class InitData { // No longer extends AsyncTask

    private String PREFS_NAME = null;
    private int MODE_PRIVATE = 0;
    private String KEY_DIRECTORY_URI = null;
    private Context mContext;
    private MainActivity mainAct;
    private SharedPreferences settings = null;
    private ProgressDialog pd = null;
    private Uri selectedDirectoryUri;
    private String csvFile = null;
    private String errorMsg = null;
    private ReadMileageData rmd = null;
    private ExecutorService executorService; // For background tasks
    private Handler mainHandler; // For UI updates

    InitData(MainActivity act, Context context, String PNAME, int MPRIV, String KDU) {
        mainAct = act;
        mContext = context;
        PREFS_NAME = PNAME;
        MODE_PRIVATE = MPRIV;
        KEY_DIRECTORY_URI = KDU;
        executorService = Executors.newSingleThreadExecutor(); // Using a single thread for sequential tasks
        mainHandler = new Handler(Looper.getMainLooper()); // Handler for posting to the UI thread
    }

    // Method to initiate the initialization process
    public void startInitialization(MyApplication myApp, Uri uri) {
        onPreExecute(); // Call onPreExecute directly

        executorService.execute(() -> { // Use the ExecutorService for background work
                    // Simulating doInBackground
                    settings = myApp.getSharedPreferences(PREFS_NAME, MODE_PRIVATE);
                    selectedDirectoryUri = uri;
                    String data = null;
                    try {
                        data = settings.getString("CarInfo", "");
                        android.util.Log.e("InitData", "Pulled out Car Info: " + data);
                    } catch (Exception e) {
                        data = "";
                    }
                    if ((data != null) && (data != "")) {
                        myApp.carInfo().save(data);
                        data = settings.getString("CurrentCar", "");
                        android.util.Log.e("InitData", "Pulled out CurrrentCar: " + data);
                        myApp.carInfo().setCurrentCar(data);
                        csvFile = myApp.carInfo().csvFile();
                        android.util.Log.e("InitData", "Pulled out csvFile: " + csvFile);
                    }
                    myApp.setFileState(false);
                    if ((csvFile != null) && (csvFile != "")) {
                        rmd = new ReadMileageData(mContext, selectedDirectoryUri, csvFile);
                        if (!rmd.readFile()) {
                            errorMsg = rmd.error();
                            mainHandler.post(() -> onCancelled(myApp));
                            return;
                        }
                    }
                });
            // Post onPostExecute to the UI thread
        mainHandler.post(() -> onPostExecute(myApp));
    }

    protected void onPreExecute() {
        pd = new ProgressDialog(mContext);
        pd.setIndeterminate(true);
        pd.setIndeterminateDrawable(mainAct.getResources().getDrawable(R.drawable.progress_dialog_anim));
        pd.setCancelable(false);
        pd.setTitle("Initalizing");
        pd.setMessage("Setting up Data");
        pd.show();
    }

    protected void onCancelled(MyApplication myApp) {
        if (pd != null && pd.isShowing()) {
            pd.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
        builder.setTitle("Error in Initalization");
        builder.setMessage("Sorry, there was an error trying to initalize the data.\n\n" + errorMsg);
        builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int arg1) {
                dialog.dismiss();
            }
        });
        builder.setCancelable(false);
        AlertDialog myAlertDialog = builder.create();
        myAlertDialog.show();
    }

    protected void onPostExecute(final MyApplication myApp) {
        if (rmd != null) {
            for (MileageData md : rmd.getMileageData()) {
                myApp.addData(md);
            }
            myApp.setFileState(true);
        } else {
            myApp.setFileState(false);
        }
        myApp.setChanged(false);
        myApp.notifyDataSetChanged(true);
        if (pd != null && pd.isShowing()) {
            pd.dismiss();
        }

        View dialogView = null;
        AlertDialog.Builder dialog = null;
        csvFile = myApp.carInfo().csvFile();
        if ((csvFile == null) || (csvFile == "")) {
            myApp.getActivity().addCarDialog();
        }
    }
}
