package com.ving.gasmileage;

import android.content.Context;
import android.content.ContentResolver;
import android.database.Cursor;
import android.provider.DocumentsContract;
import android.net.Uri;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.ArrayList;

public class ReadMileageData {
	private Context mContext;
	private Uri externDir;
	private String file = null;
	private Uri myFile = null;
	private Boolean notCanceled = null;
	private ArrayList<String> rowData = null;
	private ArrayList<MileageData> mileageData = null;
	private String errorMsg = null;
	private MileageData md = null;

	ReadMileageData(Context context, Uri uri, String fileName) {
		mContext = context;
		externDir = uri;
		file = fileName;
		myFile = findFileInDirectory(file);
	}

	private Uri findFileInDirectory(String filename) {
		ContentResolver contentResolver = null;
		try {
			contentResolver = mContext.getContentResolver();
		} catch (Exception e) {
			return null;
		}
		if (externDir == null) {
			return null;
		}
		Uri childrenUri = DocumentsContract.buildChildDocumentsUriUsingTree(
				externDir,
				DocumentsContract.getTreeDocumentId(externDir)
		);

		try {
			Cursor cursor = contentResolver.query(childrenUri,
					new String[]{DocumentsContract.Document.COLUMN_DOCUMENT_ID, DocumentsContract.Document.COLUMN_DISPLAY_NAME},
					null, null, null);
			if (cursor != null && cursor.moveToFirst()) {
				do {
					String displayName = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DISPLAY_NAME));
					if (displayName.equals(filename)) {
						String documentId = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DOCUMENT_ID));
						return DocumentsContract.buildDocumentUriUsingTree(externDir, documentId);
					}
				} while (cursor.moveToNext());
			}
		} catch (Exception e) {
			errorMsg = e.toString();
		}
		return null;
	}

	public Boolean readFile() {
		notCanceled = true;
		mileageData = new ArrayList<MileageData>();
		if (myFile != null) {
			InputStream iStream = null;
			BufferedReader myReader = null;
			try {
				ContentResolver contentResolver = mContext.getContentResolver();
				iStream = contentResolver.openInputStream(myFile);
				if (iStream == null) {
					throw new IOException("File not found: " + file);
				}
				myReader = new BufferedReader(new InputStreamReader(iStream));
				String row;
				rowData = new ArrayList<String>();
				while ((row = myReader.readLine()) != null) {
					rowData.add(row);
				}
				myReader.close();
				iStream.close();
			} catch (Exception e) {
				errorMsg = e.toString();
				notCanceled = false;
			}
			if (notCanceled) {
				for (String row : rowData) {
					if (!row.isEmpty()) {
						String[] rowValues = row.split(",");
						try {
							md = new MileageData(rowValues);
							mileageData.add(md);
						} catch (Exception e) {
							notCanceled = false;
							errorMsg += "\n" + row + "\n" + e.toString() + "\n";
						}
					}
				}
			}
		}

		if (!notCanceled) {
			mileageData = null;
		}

		return notCanceled;
	}
	
	public String error() {
		return errorMsg;
	}
	
	public ArrayList<MileageData> getMileageData() {
		return mileageData;
	}
}