package com.ving.gasmileage;

import android.content.Context;
import android.content.ContentResolver;
import android.database.Cursor;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import android.net.Uri;
import android.provider.DocumentsContract;

public class WriteMileageData implements Runnable {

	private MyApplication myApp = null;
	private Context mContext;
	private Uri externDir = null;
	private Uri parentDocumentUri = null;
	private String file = null;
	private Uri myFile = null;
	private Uri backupFile = null;
	private Boolean canceled = false;
	private String errorMsg = null;

	WriteMileageData(Uri externDir, String fileName, MyApplication myApp, Context context) {
		this.myApp = myApp;
		this.mContext = context;
	    file = fileName;
		this.externDir = externDir;
		parentDocumentUri = DocumentsContract.buildChildDocumentsUriUsingTree(
				this.externDir,
				DocumentsContract.getTreeDocumentId(this.externDir)
		);
		myFile = findFileInDirectory(this.file);
		backupFile = findFileInDirectory(this.file+".backup");
	}

	private Uri findFileInDirectory(String filename) {
		ContentResolver contentResolver = null;
		try {
			contentResolver = this.mContext.getContentResolver();
		} catch (Exception e) {
			return null;
		}

		try {
			Cursor cursor = contentResolver.query(parentDocumentUri,
					new String[]{DocumentsContract.Document.COLUMN_DOCUMENT_ID, DocumentsContract.Document.COLUMN_DISPLAY_NAME},
					null, null, null);
			if (cursor != null && cursor.moveToFirst()) {
				do {
					String displayName = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DISPLAY_NAME));
					if (displayName.equals(filename)) {
						String documentId = cursor.getString(cursor.getColumnIndexOrThrow(DocumentsContract.Document.COLUMN_DOCUMENT_ID));
						return DocumentsContract.buildDocumentUriUsingTree(this.externDir, documentId);
					}
				} while (cursor.moveToNext());
			}
		} catch (Exception e) {
			canceled = true;
			errorMsg = e.toString();
			myApp.popUpMessage("No Data Written", "Sorry, there was an error trying to read the directory.\n" + errorMsg);
		}
		return null;
	}

	@Override
	public void run() {
		MileageData md;
		ContentResolver contentResolver = this.mContext.getContentResolver();
		if (this.myFile != null) {
			try {
				if (this.backupFile == null) {
					this.backupFile = DocumentsContract.createDocument(contentResolver, parentDocumentUri, "application/octet-stream", this.file + ".backup");
				}
				if (this.backupFile == null) {
					myApp.toastMessage("Unable to create backup file.");
				} else {
					InputStream iStream = contentResolver.openInputStream(this.myFile);
					OutputStream oStream = contentResolver.openOutputStream(this.backupFile);
					if (oStream != null && iStream != null) {
						byte[] buffer = new byte[1024];
						int read;
						while ((read = iStream.read(buffer)) != -1) {
							oStream.write(buffer, 0, read);
						}
						iStream.close();
						iStream = null;
						oStream.flush();
						oStream.close();
						oStream = null;
					} else {
						canceled = true;
						myApp.popUpMessage("No Data Written", "Sorry, there was an error trying to backup the CSV file.");
					}
				}
			} catch(Exception e) {
				canceled = true;
				errorMsg = e.toString();
				myApp.popUpMessage("No Data Written", "Sorry, there was an error trying to backup the CSV file.\n"+errorMsg);
			}
		}
		if (! canceled) {
			try {
				if (this.myFile == null) {
					this.myFile = DocumentsContract.createDocument(contentResolver, parentDocumentUri, "text/csv", this.file);
					if (this.myFile == null) {
						canceled = true;
						myApp.popUpMessage("No Data Writeen", "Sorry, there was an error trying to create the CSV file.");
					}
				}
				if (this.myFile != null) {
					OutputStream oStream = contentResolver.openOutputStream(this.myFile);
					if (oStream != null) {
						BufferedWriter myWriter = new BufferedWriter(new OutputStreamWriter(oStream));
						myWriter.write(myApp.toCSV());
						myWriter.flush();
						myWriter.close();
						oStream.close();
					} else {
						canceled = true;
						myApp.popUpMessage("No Data Written", "Sorry, there was an error trying to write the file.");
					}
				}
			}catch(Exception e) {
				canceled = true;
				errorMsg = e.toString();
				myApp.popUpMessage("No Data Written", "Sorry, there was an error trying to write the file.\n" + errorMsg);
			}
		}
		if (! canceled) {
			myApp.setFileState(true);
			myApp.setChanged(false);
			myApp.toastMessage("Finished Saving CSV File "+file);
		}
	}

}