package com.ving.gasmileage;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ReadAsyncTask {

    private final Context mContext;
    private final Uri externDir;
    private final String csvFile;
    private Boolean newFile = false;
    private String task = null;
    private String errorMsg = null;
    private ReadMileageData rmd = null;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private InitData.OnInitCompleteListener mListener;

    ReadAsyncTask(String filename, Uri dir, Context context, Boolean newFile) {
        this.csvFile = filename;
        this.externDir = dir;
        this.mContext = context;
        this.newFile = newFile;
    }

    public void setOnReadCompleteListener(InitData.OnInitCompleteListener listener) {
        this.mListener = listener;
    }

    public void execute(final MyApplication myApp) {
        myApp.performingReadTask();
        executor.execute(() -> {
            rmd = new ReadMileageData(mContext, externDir, csvFile, newFile);
            // Get this ready
            if (!rmd.setUpData()) {
                task = "Finding CSV file in directory";
                errorMsg = rmd.error();
                mainHandler.post(this::postError);
            } else {
                if (!rmd.readFile()) {
                    task = "Reading the CSV file";
                    errorMsg = rmd.error();
                    mainHandler.post(this::postError);
                } else {
                    for (MileageData md : rmd.getMileageData()) {
                        myApp.addData(md);
                    }
                    mainHandler.post(this::onPostExecute);
                }
            }
        });
    }

    private void onPostExecute() {
        // Notify the MainActivity that the task is complete
        if (mListener != null) {
            mListener.onInitComplete();
        }
    }

    private void postError() {
        // Notify the MainActivity of the error
        if (mListener != null) {
            mListener.onInitError(task + "\n" + errorMsg);
        }
    }
}
